<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'key' => env('POSTMARK_API_KEY'),
    ],

    'resend' => [
        'key' => env('RESEND_API_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'order_processing' => [
        'email_webhook_secret' => env('ORDER_EMAIL_WEBHOOK_SECRET'),
        'whatsapp_webhook_secret' => env('ORDER_WHATSAPP_WEBHOOK_SECRET'),
        'admin_email' => env('ORDER_ADMIN_EMAIL', 'info@onespotsolutionsltd.co.ke'),
        'whatsapp_admin' => env('WHATSAPP_ADMIN_NUMBER', '254743456809'),
    ],

];
