<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'CCTV Cameras',
                'description' => 'High-quality surveillance cameras for security monitoring',
                'children' => [
                    ['name' => 'Dome Cameras', 'description' => 'Indoor/outdoor dome-style cameras'],
                    ['name' => 'Bullet Cameras', 'description' => 'Long-range bullet-style cameras'],
                    ['name' => 'PTZ Cameras', 'description' => 'Pan-Tilt-Zoom controllable cameras'],
                    ['name' => 'IP Cameras', 'description' => 'Network-connected digital cameras'],
                    ['name' => 'Analog Cameras', 'description' => 'Traditional analog surveillance cameras'],
                ],
            ],
            [
                'name' => 'Access Controls',
                'description' => 'Electronic access control systems and biometrics',
                'children' => [
                    ['name' => 'Fingerprint Readers', 'description' => 'Biometric fingerprint scanners'],
                    ['name' => 'Face Recognition', 'description' => 'Facial recognition access systems'],
                    ['name' => 'Card Access Systems', 'description' => 'RFID and NFC card readers'],
                    ['name' => 'PIN Keypads', 'description' => 'Keypad entry systems'],
                ],
            ],
            [
                'name' => 'CCTV Components',
                'description' => 'Recording devices and accessories for CCTV systems',
                'children' => [
                    ['name' => 'DVR/NVR', 'description' => 'Digital and network video recorders'],
                    ['name' => 'Hard Drives', 'description' => 'Surveillance-grade storage drives'],
                    ['name' => 'Power Supplies', 'description' => 'Power adapters and UPS units'],
                    ['name' => 'Cables & Connectors', 'description' => 'Video and power cables'],
                ],
            ],
            [
                'name' => 'Smart Locks',
                'description' => 'Electronic and smart locking systems',
                'children' => [
                    ['name' => 'Electronic Door Locks', 'description' => 'Digital keypad door locks'],
                    ['name' => 'Smart Deadbolts', 'description' => 'App-controlled deadbolt locks'],
                    ['name' => 'Cabinet Locks', 'description' => 'Electronic cabinet and drawer locks'],
                ],
            ],
            [
                'name' => 'Electric Fencing',
                'description' => 'Perimeter security electric fence systems',
                'children' => [
                    ['name' => 'Energizers', 'description' => 'Electric fence power units'],
                    ['name' => 'Fence Wire', 'description' => 'Galvanized and aluminum fence wire'],
                    ['name' => 'Fence Accessories', 'description' => 'Insulators, brackets, and clips'],
                ],
            ],
            [
                'name' => 'Barrier Gates',
                'description' => 'Vehicle access control barriers',
                'children' => [
                    ['name' => 'Boom Barriers', 'description' => 'Automatic boom gate systems'],
                    ['name' => 'Turnstiles', 'description' => 'Pedestrian turnstile gates'],
                    ['name' => 'Sliding Gates', 'description' => 'Automated sliding gate motors'],
                ],
            ],
            [
                'name' => 'License Plate Recognition',
                'description' => 'ANPR/LPR camera systems',
                'children' => [
                    ['name' => 'ANPR Cameras', 'description' => 'Automatic number plate recognition cameras'],
                    ['name' => 'LPR Software', 'description' => 'License plate recognition software'],
                ],
            ],
            [
                'name' => 'Security Gadgets',
                'description' => 'Alarms, sensors, and security accessories',
                'children' => [
                    ['name' => 'Motion Sensors', 'description' => 'PIR and microwave motion detectors'],
                    ['name' => 'Alarm Systems', 'description' => 'Burglar and intrusion alarms'],
                    ['name' => 'Intercoms', 'description' => 'Audio and video intercom systems'],
                    ['name' => 'Smoke Detectors', 'description' => 'Fire and smoke detection devices'],
                ],
            ],
            [
                'name' => 'Networking Equipment',
                'description' => 'Network infrastructure and connectivity devices',
                'children' => [
                    ['name' => 'Network Switches', 'description' => 'Managed and unmanaged switches'],
                    ['name' => 'Routers', 'description' => 'Enterprise and home routers'],
                    ['name' => 'PoE Injectors', 'description' => 'Power over Ethernet adapters'],
                    ['name' => 'Network Cables', 'description' => 'Cat5e, Cat6, and fiber cables'],
                    ['name' => 'Wireless Access Points', 'description' => 'WiFi access points and repeaters'],
                ],
            ],
        ];

        $sortOrder = 0;
        foreach ($categories as $categoryData) {
            $children = $categoryData['children'] ?? [];
            unset($categoryData['children']);
            
            $category = Category::create([
                'name' => $categoryData['name'],
                'slug' => Str::slug($categoryData['name']),
                'description' => $categoryData['description'] ?? null,
                'sort_order' => $sortOrder++,
                'is_active' => true,
            ]);

            $childSortOrder = 0;
            foreach ($children as $child) {
                Category::create([
                    'name' => $child['name'],
                    'slug' => Str::slug($child['name']),
                    'description' => $child['description'] ?? null,
                    'parent_id' => $category->id,
                    'sort_order' => $childSortOrder++,
                    'is_active' => true,
                ]);
            }
        }
    }
}
