@extends('admin.layouts.app')

@section('title', 'Edit Category')

@section('content')
<div class="card" style="max-width: 600px;">
    <div class="card-header">
        <h3 class="card-title">Edit Category: {{ $category->name }}</h3>
    </div>

    <form method="POST" action="{{ route('admin.categories.update', $category) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="form-group">
            <label class="form-label">Category Name *</label>
            <input type="text" name="name" class="form-input" value="{{ old('name', $category->name) }}" required>
        </div>

        <div class="form-group">
            <label class="form-label">Parent Category</label>
            <select name="parent_id" class="form-select">
                <option value="">None (Top-level category)</option>
                @foreach($parentCategories as $parent)
                    <option value="{{ $parent->id }}" {{ old('parent_id', $category->parent_id) == $parent->id ? 'selected' : '' }}>
                        {{ $parent->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label class="form-label">Description</label>
            <textarea name="description" class="form-textarea" rows="3">{{ old('description', $category->description) }}</textarea>
        </div>

        @if($category->image)
        <div class="form-group">
            <label class="form-label">Current Image</label>
            <div>
                <img src="{{ asset('storage/' . $category->image) }}" alt="{{ $category->name }}" 
                     style="width: 100px; height: 100px; object-fit: cover; border-radius: 8px;">
            </div>
        </div>
        @endif

        <div class="form-group">
            <label class="form-label">{{ $category->image ? 'Change Image' : 'Category Image' }}</label>
            <input type="file" name="image" class="form-input" accept="image/*">
        </div>

        <div class="form-group">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $category->is_active) ? 'checked' : '' }}>
                <span>Active</span>
            </label>
        </div>

        <div class="flex gap-3">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Update Category
            </button>
            <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>
@endsection
