@extends('admin.layouts.app')

@section('title', 'Categories')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">All Categories</h3>
        <a href="{{ route('admin.categories.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add Category
        </a>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Category</th>
                    <th>Subcategories</th>
                    <th>Products</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($categories as $category)
                <tr>
                    <td>
                        <div class="flex items-center gap-3">
                            @if($category->image)
                                <img src="{{ asset('storage/' . $category->image) }}" 
                                     alt="{{ $category->name }}" 
                                     style="width: 40px; height: 40px; object-fit: cover; border-radius: 8px;">
                            @else
                                <div style="width: 40px; height: 40px; background: rgba(100,116,139,0.3); border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-folder text-muted"></i>
                                </div>
                            @endif
                            <div>
                                <strong>{{ $category->name }}</strong>
                                @if($category->description)
                                    <div class="text-muted" style="font-size: 0.8rem;">{{ Str::limit($category->description, 50) }}</div>
                                @endif
                            </div>
                        </div>
                    </td>
                    <td>{{ $category->children_count }}</td>
                    <td>{{ $category->products_count }}</td>
                    <td>
                        @if($category->is_active)
                            <span class="badge badge-success">Active</span>
                        @else
                            <span class="badge badge-secondary">Inactive</span>
                        @endif
                    </td>
                    <td>
                        <div class="flex gap-2">
                            <a href="{{ route('admin.categories.edit', $category) }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form method="POST" action="{{ route('admin.categories.destroy', $category) }}" 
                                  onsubmit="return confirm('Are you sure? This will also delete all subcategories.')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                
                <!-- Subcategories -->
                @foreach($category->children as $child)
                <tr style="background: rgba(0,0,0,0.1);">
                    <td style="padding-left: 3rem;">
                        <div class="flex items-center gap-3">
                            <i class="fas fa-turn-up text-muted" style="transform: rotate(90deg);"></i>
                            @if($child->image)
                                <img src="{{ asset('storage/' . $child->image) }}" 
                                     alt="{{ $child->name }}" 
                                     style="width: 32px; height: 32px; object-fit: cover; border-radius: 6px;">
                            @endif
                            <span>{{ $child->name }}</span>
                        </div>
                    </td>
                    <td>-</td>
                    <td>{{ $child->products_count ?? 0 }}</td>
                    <td>
                        @if($child->is_active)
                            <span class="badge badge-success">Active</span>
                        @else
                            <span class="badge badge-secondary">Inactive</span>
                        @endif
                    </td>
                    <td>
                        <div class="flex gap-2">
                            <a href="{{ route('admin.categories.edit', $child) }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form method="POST" action="{{ route('admin.categories.destroy', $child) }}" 
                                  onsubmit="return confirm('Delete this subcategory?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @endforeach
                @empty
                <tr>
                    <td colspan="5" class="text-muted" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-folder-tree" style="font-size: 2rem; margin-bottom: 1rem; display: block;"></i>
                        No categories found. <a href="{{ route('admin.categories.create') }}" class="text-primary">Add your first category</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
