@extends('admin.layouts.app')

@section('title', 'Orders')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">All Orders</h3>
    </div>

    <!-- Filters -->
    <form method="GET" class="mb-3">
        <div class="flex gap-3 items-center">
            <input type="text" name="search" class="form-input" placeholder="Search by order #, name, email..." 
                   value="{{ request('search') }}" style="max-width: 300px;">
            
            <select name="status" class="form-select" style="max-width: 150px;">
                <option value="">All Status</option>
                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="processing" {{ request('status') == 'processing' ? 'selected' : '' }}>Processing</option>
                <option value="confirmed" {{ request('status') == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                <option value="shipped" {{ request('status') == 'shipped' ? 'selected' : '' }}>Shipped</option>
                <option value="delivered" {{ request('status') == 'delivered' ? 'selected' : '' }}>Delivered</option>
                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
            </select>

            <select name="payment_status" class="form-select" style="max-width: 150px;">
                <option value="">All Payments</option>
                <option value="pending" {{ request('payment_status') == 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="paid" {{ request('payment_status') == 'paid' ? 'selected' : '' }}>Paid</option>
                <option value="failed" {{ request('payment_status') == 'failed' ? 'selected' : '' }}>Failed</option>
            </select>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Filter
            </button>
            
            @if(request()->hasAny(['search', 'status', 'payment_status']))
                <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary">Clear</a>
            @endif
        </div>
    </form>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Order #</th>
                    <th>Customer</th>
                    <th>Items</th>
                    <th>Total</th>
                    <th>Payment</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($orders as $order)
                <tr>
                    <td>
                        <a href="{{ route('admin.orders.show', $order) }}" class="text-primary">
                            <strong>{{ $order->order_number }}</strong>
                        </a>
                    </td>
                    <td>
                        <div>
                            <strong>{{ $order->customer_name }}</strong>
                            <div class="text-muted" style="font-size: 0.8rem;">{{ $order->customer_phone }}</div>
                        </div>
                    </td>
                    <td>{{ $order->items->count() }} items</td>
                    <td><strong>KSh {{ number_format($order->total, 2) }}</strong></td>
                    <td>
                        <span class="badge badge-{{ $order->payment_status_badge['color'] }}">
                            {{ $order->payment_status_badge['label'] }}
                        </span>
                        @if($order->payment_method)
                            <div class="text-muted" style="font-size: 0.75rem; margin-top: 2px;">
                                {{ strtoupper($order->payment_method) }}
                            </div>
                        @endif
                    </td>
                    <td>
                        <span class="badge badge-{{ $order->status_badge['color'] }}">
                            {{ $order->status_badge['label'] }}
                        </span>
                    </td>
                    <td>
                        <div class="text-muted" style="font-size: 0.85rem;">
                            {{ $order->created_at->format('M d, Y') }}
                            <br>
                            <span style="font-size: 0.75rem;">{{ $order->created_at->format('h:i A') }}</span>
                        </div>
                    </td>
                    <td>
                        <a href="{{ route('admin.orders.show', $order) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="text-muted" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-shopping-cart" style="font-size: 2rem; margin-bottom: 1rem; display: block;"></i>
                        No orders yet
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{ $orders->links() }}
</div>
@endsection
