@extends('admin.layouts.app')

@section('title', 'Order ' . $order->order_number)

@section('content')
<div class="flex justify-between items-center mb-3">
    <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Orders
    </a>
    <div class="flex gap-2">
        <a href="{{ $customerLink }}" target="_blank" class="btn" style="background: #25D366; color: white;">
            <i class="fab fa-whatsapp"></i> Send Invoice to Customer
        </a>
    </div>
</div>

<div class="grid grid-2">
    <!-- Order Info -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Order Details</h3>
            <span class="badge badge-{{ $order->status_badge['color'] }}" style="font-size: 0.9rem;">
                {{ $order->status_badge['label'] }}
            </span>
        </div>

        <div class="grid grid-2">
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Order Number</div>
                <strong>{{ $order->order_number }}</strong>
            </div>
            <div>
                <div class="text-muted" style="font-size: 0.8rem;">Date</div>
                <strong>{{ $order->created_at->format('M d, Y h:i A') }}</strong>
            </div>
        </div>

        <hr style="border-color: rgba(255,255,255,0.1); margin: 1rem 0;">

        <!-- Update Status -->
        <form method="POST" action="{{ route('admin.orders.update-status', $order) }}" class="mb-3">
            @csrf
            @method('PATCH')
            <div class="flex gap-2 items-center">
                <select name="status" class="form-select" style="flex: 1;">
                    <option value="pending" {{ $order->status == 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="processing" {{ $order->status == 'processing' ? 'selected' : '' }}>Processing</option>
                    <option value="confirmed" {{ $order->status == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                    <option value="shipped" {{ $order->status == 'shipped' ? 'selected' : '' }}>Shipped</option>
                    <option value="delivered" {{ $order->status == 'delivered' ? 'selected' : '' }}>Delivered</option>
                    <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                </select>
                <button type="submit" class="btn btn-primary btn-sm">Update Status</button>
            </div>
        </form>

        <!-- Update Payment Status -->
        <form method="POST" action="{{ route('admin.orders.update-payment-status', $order) }}">
            @csrf
            @method('PATCH')
            <div class="flex gap-2 items-center">
                <select name="payment_status" class="form-select" style="flex: 1;">
                    <option value="pending" {{ $order->payment_status == 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="paid" {{ $order->payment_status == 'paid' ? 'selected' : '' }}>Paid</option>
                    <option value="failed" {{ $order->payment_status == 'failed' ? 'selected' : '' }}>Failed</option>
                    <option value="refunded" {{ $order->payment_status == 'refunded' ? 'selected' : '' }}>Refunded</option>
                </select>
                <button type="submit" class="btn btn-primary btn-sm">Update Payment</button>
            </div>
        </form>
    </div>

    <!-- Customer Info -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Customer Information</h3>
        </div>

        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Name</div>
            <strong>{{ $order->customer_name }}</strong>
        </div>

        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Email</div>
            <a href="mailto:{{ $order->customer_email }}" class="text-primary">{{ $order->customer_email }}</a>
        </div>

        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Phone</div>
            <a href="tel:{{ $order->customer_phone }}" class="text-primary">{{ $order->customer_phone }}</a>
        </div>

        @if($order->shipping_address)
        <div class="mb-2">
            <div class="text-muted" style="font-size: 0.8rem;">Shipping Address</div>
            <div>{{ $order->shipping_address }}</div>
            @if($order->city || $order->county)
                <div>{{ $order->city }}{{ $order->county ? ', ' . $order->county : '' }}</div>
            @endif
        </div>
        @endif

        @if($order->notes)
        <div>
            <div class="text-muted" style="font-size: 0.8rem;">Order Notes</div>
            <div>{{ $order->notes }}</div>
        </div>
        @endif
    </div>
</div>

<!-- Order Items -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Order Items</h3>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Product</th>
                    <th>SKU</th>
                    <th>Price</th>
                    <th>Quantity</th>
                    <th>Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($order->items as $item)
                <tr>
                    <td>
                        <strong>{{ $item->product_name }}</strong>
                        @if($item->includes_installation)
                            <div class="badge badge-info" style="margin-top: 4px;">+ Installation</div>
                        @endif
                    </td>
                    <td>{{ $item->product_sku }}</td>
                    <td>KSh {{ number_format($item->price, 2) }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>
                        <strong>KSh {{ number_format($item->subtotal, 2) }}</strong>
                        @if($item->includes_installation)
                            <div class="text-muted" style="font-size: 0.8rem;">
                                + KSh {{ number_format($item->installation_price * $item->quantity, 2) }} installation
                            </div>
                        @endif
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <!-- Totals -->
    <div style="margin-top: 1.5rem; padding-top: 1rem; border-top: 1px solid rgba(255,255,255,0.1);">
        <div class="flex justify-between mb-1">
            <span>Subtotal</span>
            <span>KSh {{ number_format($order->subtotal, 2) }}</span>
        </div>
        @if($order->shipping_cost > 0)
        <div class="flex justify-between mb-1">
            <span>Shipping</span>
            <span>KSh {{ number_format($order->shipping_cost, 2) }}</span>
        </div>
        @endif
        @if($order->installation_cost > 0)
        <div class="flex justify-between mb-1">
            <span>Installation</span>
            <span>KSh {{ number_format($order->installation_cost, 2) }}</span>
        </div>
        @endif
        @if($order->installation_discount > 0)
        <div class="flex justify-between mb-1 text-success">
            <span>Installation Discount (Shop Customer)</span>
            <span>- KSh {{ number_format($order->installation_discount, 2) }}</span>
        </div>
        @endif
        @if($order->discount > 0)
        <div class="flex justify-between mb-1 text-success">
            <span>Discount</span>
            <span>- KSh {{ number_format($order->discount, 2) }}</span>
        </div>
        @endif
        <div class="flex justify-between" style="font-size: 1.25rem; font-weight: 700; margin-top: 0.5rem; padding-top: 0.5rem; border-top: 1px solid rgba(255,255,255,0.1);">
            <span>Total</span>
            <span>KSh {{ number_format($order->total, 2) }}</span>
        </div>
    </div>
</div>

<!-- Payment History -->
@if($order->payments->count() > 0)
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Payment History</h3>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Method</th>
                    <th>Transaction ID</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                @foreach($order->payments as $payment)
                <tr>
                    <td>{{ strtoupper($payment->payment_method) }}</td>
                    <td>{{ $payment->transaction_id ?? '-' }}</td>
                    <td>KSh {{ number_format($payment->amount, 2) }}</td>
                    <td>
                        <span class="badge badge-{{ $payment->status_badge['color'] }}">
                            {{ $payment->status_badge['label'] }}
                        </span>
                    </td>
                    <td>{{ $payment->created_at->format('M d, Y h:i A') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif
@endsection
