@extends('admin.layouts.app')

@section('title', 'Add Product')

@section('content')
<form method="POST" action="{{ route('admin.products.store') }}" enctype="multipart/form-data">
    @csrf
    
    <div class="grid grid-2">
        <!-- Main Info -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Product Information</h3>
            </div>

            <div class="form-group">
                <label class="form-label">Product Name *</label>
                <input type="text" name="name" class="form-input" value="{{ old('name') }}" required>
            </div>

            <div class="grid grid-2">
                <div class="form-group">
                    <label class="form-label">SKU *</label>
                    <input type="text" name="sku" class="form-input" value="{{ old('sku') }}" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Category *</label>
                    <select name="category_id" class="form-select" required>
                        <option value="">Select Category</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                {{ $category->name }}
                            </option>
                            @foreach($category->children as $child)
                                <option value="{{ $child->id }}" {{ old('category_id') == $child->id ? 'selected' : '' }}>
                                    &nbsp;&nbsp;└ {{ $child->name }}
                                </option>
                            @endforeach
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Short Description</label>
                <textarea name="short_description" class="form-textarea" rows="2">{{ old('short_description') }}</textarea>
            </div>

            <div class="form-group">
                <label class="form-label">Full Description</label>
                <textarea name="description" class="form-textarea" rows="5">{{ old('description') }}</textarea>
            </div>
        </div>

        <!-- Pricing & Stock -->
        <div>
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Pricing & Stock</h3>
                </div>

                <div class="grid grid-2">
                    <div class="form-group">
                        <label class="form-label">Price (KSh) *</label>
                        <input type="number" name="price" class="form-input" value="{{ old('price') }}" step="0.01" min="0" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Sale Price (KSh)</label>
                        <input type="number" name="sale_price" class="form-input" value="{{ old('sale_price') }}" step="0.01" min="0">
                    </div>
                </div>

                <div class="grid grid-2">
                    <div class="form-group">
                        <label class="form-label">Stock Quantity *</label>
                        <input type="number" name="stock_quantity" class="form-input" value="{{ old('stock_quantity', 0) }}" min="0" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Weight (kg)</label>
                        <input type="number" name="weight" class="form-input" value="{{ old('weight') }}" step="0.01" min="0">
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Additional Info</h3>
                </div>

                <div class="grid grid-2">
                    <div class="form-group">
                        <label class="form-label">Brand</label>
                        <input type="text" name="brand" class="form-input" value="{{ old('brand') }}">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Model</label>
                        <input type="text" name="model" class="form-input" value="{{ old('model') }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="form-label">Warranty</label>
                    <input type="text" name="warranty" class="form-input" value="{{ old('warranty') }}" placeholder="e.g., 1 year">
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Installation Service</h3>
                </div>

                <div class="form-group">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="requires_installation" value="1" {{ old('requires_installation') ? 'checked' : '' }}>
                        <span>This product requires/offers installation service</span>
                    </label>
                </div>

                <div class="form-group">
                    <label class="form-label">Installation Price (KSh)</label>
                    <input type="number" name="installation_price" class="form-input" value="{{ old('installation_price') }}" step="0.01" min="0">
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Status</h3>
                </div>

                <div class="form-group">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                        <span>Active (visible in shop)</span>
                    </label>
                </div>

                <div class="form-group mb-0">
                    <label class="flex items-center gap-2">
                        <input type="checkbox" name="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }}>
                        <span>Featured Product</span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Images -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Product Images</h3>
        </div>

        <div class="form-group mb-0">
            <input type="file" name="images[]" class="form-input" accept="image/*" multiple>
            <small class="text-muted">Upload multiple images. First image will be the primary image.</small>
        </div>
    </div>

    <!-- Specifications -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Technical Specifications</h3>
        </div>

        <div id="specifications">
            <div class="flex gap-3 mb-2 spec-row">
                <input type="text" name="specifications[0][key]" class="form-input" placeholder="Specification name (e.g., Resolution)">
                <input type="text" name="specifications[0][value]" class="form-input" placeholder="Value (e.g., 4K Ultra HD)">
                <button type="button" class="btn btn-danger btn-sm remove-spec" style="display: none;"><i class="fas fa-times"></i></button>
            </div>
        </div>
        <button type="button" id="add-spec" class="btn btn-secondary btn-sm">
            <i class="fas fa-plus"></i> Add Specification
        </button>
    </div>

    <!-- Submit -->
    <div class="flex gap-3">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Create Product
        </button>
        <a href="{{ route('admin.products.index') }}" class="btn btn-secondary">Cancel</a>
    </div>
</form>

@push('scripts')
<script>
    let specIndex = 1;
    document.getElementById('add-spec').addEventListener('click', function() {
        const container = document.getElementById('specifications');
        const row = document.createElement('div');
        row.className = 'flex gap-3 mb-2 spec-row';
        row.innerHTML = `
            <input type="text" name="specifications[${specIndex}][key]" class="form-input" placeholder="Specification name">
            <input type="text" name="specifications[${specIndex}][value]" class="form-input" placeholder="Value">
            <button type="button" class="btn btn-danger btn-sm remove-spec"><i class="fas fa-times"></i></button>
        `;
        container.appendChild(row);
        specIndex++;
        updateRemoveButtons();
    });

    document.getElementById('specifications').addEventListener('click', function(e) {
        if (e.target.closest('.remove-spec')) {
            e.target.closest('.spec-row').remove();
            updateRemoveButtons();
        }
    });

    function updateRemoveButtons() {
        const rows = document.querySelectorAll('.spec-row');
        rows.forEach((row, index) => {
            const btn = row.querySelector('.remove-spec');
            btn.style.display = rows.length > 1 ? 'block' : 'none';
        });
    }
</script>
@endpush
@endsection
