<x-guest-layout>
    <div class="auth-form-header">
        <h2>Create Account</h2>
        <p>Already have an account? <a href="{{ route('login') }}">Sign in instead</a></p>
    </div>

    <!-- Validation Errors -->
    @if ($errors->any())
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <div>
                @foreach ($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
            </div>
        </div>
    @endif

    <form method="POST" action="{{ route('register') }}">
        @csrf

        <!-- Name -->
        <div class="form-group">
            <label for="name" class="form-label">Full Name</label>
            <div class="input-icon-wrapper">
                <i class="fas fa-user icon"></i>
                <input 
                    id="name" 
                    type="text" 
                    name="name" 
                    class="form-input" 
                    value="{{ old('name') }}" 
                    placeholder="Enter your full name"
                    required 
                    autofocus 
                    autocomplete="name"
                >
            </div>
        </div>

        <!-- Email Address -->
        <div class="form-group">
            <label for="email" class="form-label">Email Address</label>
            <div class="input-icon-wrapper">
                <i class="fas fa-envelope icon"></i>
                <input 
                    id="email" 
                    type="email" 
                    name="email" 
                    class="form-input" 
                    value="{{ old('email') }}" 
                    placeholder="Enter your email"
                    required 
                    autocomplete="username"
                >
            </div>
        </div>

        <!-- Phone Number -->
        <div class="form-group">
            <label for="phone" class="form-label">
                Phone Number
                <span style="font-size: 0.75rem; color: var(--primary); font-weight: normal;">
                    <i class="fab fa-whatsapp"></i> WhatsApp / SMS
                </span>
            </label>
            <div class="input-icon-wrapper">
                <i class="fas fa-phone icon"></i>
                <input 
                    id="phone" 
                    type="tel" 
                    name="phone" 
                    class="form-input" 
                    value="{{ old('phone') }}" 
                    placeholder="+254 7XX XXX XXX"
                    required 
                    autocomplete="tel"
                >
            </div>
            <p style="font-size: 0.75rem; color: #64748b; margin-top: 0.5rem;">
                <i class="fas fa-info-circle"></i> Used for order updates and invoices via WhatsApp/SMS
            </p>
        </div>

        <!-- Password -->
        <div class="form-group">
            <label for="password" class="form-label">Password</label>
            <div class="input-icon-wrapper">
                <i class="fas fa-lock icon"></i>
                <input 
                    id="password" 
                    type="password" 
                    name="password" 
                    class="form-input" 
                    placeholder="Create a password"
                    required 
                    autocomplete="new-password"
                >
                <button type="button" class="toggle-password">
                    <i class="fas fa-eye"></i>
                </button>
            </div>
            <p style="font-size: 0.75rem; color: #64748b; margin-top: 0.5rem;">
                <i class="fas fa-info-circle"></i> Must be at least 8 characters
            </p>
        </div>

        <!-- Confirm Password -->
        <div class="form-group">
            <label for="password_confirmation" class="form-label">Confirm Password</label>
            <div class="input-icon-wrapper">
                <i class="fas fa-lock icon"></i>
                <input 
                    id="password_confirmation" 
                    type="password" 
                    name="password_confirmation" 
                    class="form-input" 
                    placeholder="Confirm your password"
                    required 
                    autocomplete="new-password"
                >
                <button type="button" class="toggle-password">
                    <i class="fas fa-eye"></i>
                </button>
            </div>
        </div>

        <!-- Terms & Conditions -->
        <div class="form-group">
            <div class="form-check">
                <input id="terms" type="checkbox" name="terms" required>
                <label for="terms">
                    I agree to the <a href="#" style="color: var(--primary);">Terms of Service</a> and <a href="#" style="color: var(--primary);">Privacy Policy</a>
                </label>
            </div>
        </div>

        <!-- Submit Button -->
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-user-plus"></i>
            Create Account
        </button>
    </form>

    <div class="divider">
        <span>or register with</span>
    </div>

    <div class="social-login">
        <a href="#" class="social-btn">
            <i class="fab fa-google"></i>
            Google
        </a>
        <a href="#" class="social-btn">
            <i class="fab fa-facebook-f"></i>
            Facebook
        </a>
    </div>
</x-guest-layout>
