@extends('shop.layouts.app')

@section('title', 'Categories - Onespot Solutions Shop')
@section('description', 'Browse security equipment by category - CCTV cameras, access controls, smart locks, and more.')

@section('content')
<style>
    .categories-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 2rem;
    }

    .category-card {
        background: linear-gradient(135deg, rgba(30, 41, 59, 0.8) 0%, rgba(15, 23, 42, 0.8) 100%);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 20px;
        padding: 2.5rem;
        text-align: center;
        transition: all 0.3s;
        position: relative;
        overflow: hidden;
    }

    .category-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, var(--primary), var(--success));
        opacity: 0;
        transition: opacity 0.3s;
    }

    .category-card:hover {
        transform: translateY(-8px);
        border-color: rgba(14, 165, 233, 0.5);
        box-shadow: 0 25px 50px -15px rgba(14, 165, 233, 0.2);
    }

    .category-card:hover::before {
        opacity: 1;
    }

    .category-icon {
        width: 80px;
        height: 80px;
        background: rgba(14, 165, 233, 0.1);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
        transition: all 0.3s;
    }

    .category-card:hover .category-icon {
        background: rgba(14, 165, 233, 0.2);
        transform: scale(1.1);
    }

    .category-icon i {
        font-size: 2rem;
        color: var(--primary);
    }

    .category-card h3 {
        font-size: 1.25rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .category-card .product-count {
        color: #64748b;
        font-size: 0.9rem;
        margin-bottom: 1rem;
    }

    .category-card p {
        color: #94a3b8;
        font-size: 0.9rem;
        margin-bottom: 1.5rem;
        line-height: 1.6;
    }

    .subcategories {
        display: flex;
        flex-wrap: wrap;
        gap: 0.5rem;
        justify-content: center;
        margin-bottom: 1.5rem;
    }

    .subcategory-tag {
        background: rgba(100, 116, 139, 0.2);
        padding: 0.35rem 0.75rem;
        border-radius: 999px;
        font-size: 0.75rem;
        color: #94a3b8;
    }

    .view-products-btn {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        color: var(--primary);
        font-weight: 500;
        font-size: 0.9rem;
        transition: gap 0.2s;
    }

    .view-products-btn:hover {
        gap: 0.75rem;
    }

    /* Category Icons Mapping */
    .icon-cctv { color: #3b82f6; }
    .icon-access { color: #8b5cf6; }
    .icon-locks { color: #f59e0b; }
    .icon-fencing { color: #ef4444; }
    .icon-barriers { color: #10b981; }
    .icon-networking { color: #0ea5e9; }
</style>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <div class="breadcrumb">
            <a href="{{ route('shop.home') }}">Home</a>
            <span>/</span>
            <span>Categories</span>
        </div>
        <h1>Shop by Category</h1>
        <p>Browse our wide range of security and networking equipment</p>
    </div>
</div>

<!-- Main Content -->
<div class="main-content">
    <div class="categories-grid">
        @forelse($categories as $category)
            <div class="category-card">
                <div class="category-icon">
                    @switch(strtolower($category->name))
                        @case('cctv cameras')
                        @case('cctv')
                            <i class="fas fa-video icon-cctv"></i>
                            @break
                        @case('access control')
                            <i class="fas fa-fingerprint icon-access"></i>
                            @break
                        @case('smart locks')
                        @case('locks')
                            <i class="fas fa-lock icon-locks"></i>
                            @break
                        @case('electric fencing')
                        @case('fencing')
                            <i class="fas fa-bolt icon-fencing"></i>
                            @break
                        @case('barrier gates')
                        @case('barriers')
                            <i class="fas fa-road-barrier icon-barriers"></i>
                            @break
                        @case('networking')
                        @case('network')
                            <i class="fas fa-network-wired icon-networking"></i>
                            @break
                        @default
                            <i class="fas fa-box"></i>
                    @endswitch
                </div>
                <h3>{{ $category->name }}</h3>
                <div class="product-count">{{ $category->products_count }} Products</div>
                @if($category->description)
                    <p>{{ Str::limit($category->description, 100) }}</p>
                @endif
                
                @if($category->children && $category->children->count() > 0)
                    <div class="subcategories">
                        @foreach($category->children->take(4) as $child)
                            <span class="subcategory-tag">{{ $child->name }}</span>
                        @endforeach
                        @if($category->children->count() > 4)
                            <span class="subcategory-tag">+{{ $category->children->count() - 4 }} more</span>
                        @endif
                    </div>
                @endif
                
                <a href="{{ route('shop.products', ['category' => $category->id]) }}" class="view-products-btn">
                    View Products <i class="fas fa-arrow-right"></i>
                </a>
            </div>
        @empty
            <div style="grid-column: 1 / -1; text-align: center; padding: 4rem 2rem;">
                <i class="fas fa-folder-open" style="font-size: 4rem; color: #475569; margin-bottom: 1rem;"></i>
                <h3>No Categories Yet</h3>
                <p style="color: #64748b;">Categories will appear here once they are added.</p>
            </div>
        @endforelse
    </div>
</div>
@endsection
