@extends('shop.layouts.app')

@section('title', 'Contact Us - Onespot Solutions Shop')
@section('description', 'Get in touch with Onespot Solutions - we are here to help with all your security equipment needs.')

@section('content')
<style>
    .contact-grid {
        display: grid;
        grid-template-columns: 1fr 1.5fr;
        gap: 3rem;
    }

    .contact-info {
        display: flex;
        flex-direction: column;
        gap: 2rem;
    }

    .contact-card {
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        padding: 1.5rem;
        display: flex;
        align-items: flex-start;
        gap: 1rem;
        transition: all 0.3s;
    }

    .contact-card:hover {
        border-color: rgba(14, 165, 233, 0.3);
        transform: translateX(5px);
    }

    .contact-icon {
        width: 50px;
        height: 50px;
        background: rgba(14, 165, 233, 0.1);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .contact-icon i {
        font-size: 1.25rem;
        color: var(--primary);
    }

    .contact-card h3 {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 0.25rem;
    }

    .contact-card p {
        color: #94a3b8;
        font-size: 0.9rem;
        margin-bottom: 0.5rem;
    }

    .contact-card a {
        color: var(--primary);
        font-weight: 500;
        font-size: 0.9rem;
    }

    .business-hours {
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        padding: 1.5rem;
    }

    .business-hours h3 {
        font-size: 1.1rem;
        margin-bottom: 1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .business-hours h3 i {
        color: var(--primary);
    }

    .hours-list {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }

    .hours-item {
        display: flex;
        justify-content: space-between;
        padding: 0.5rem 0;
        border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        font-size: 0.9rem;
    }

    .hours-item span:first-child {
        color: #94a3b8;
    }

    .hours-item span:last-child {
        color: #e2e8f0;
    }

    .contact-form-card {
        background: rgba(30, 41, 59, 0.6);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 16px;
        padding: 2rem;
    }

    .contact-form-card h2 {
        font-size: 1.5rem;
        margin-bottom: 0.5rem;
    }

    .contact-form-card > p {
        color: #64748b;
        margin-bottom: 1.5rem;
    }

    .form-group {
        margin-bottom: 1.25rem;
    }

    .form-group label {
        display: block;
        font-size: 0.9rem;
        font-weight: 500;
        margin-bottom: 0.5rem;
        color: #94a3b8;
    }

    .form-group label .required {
        color: var(--danger);
    }

    .form-control {
        width: 100%;
        padding: 0.75rem 1rem;
        background: rgba(15, 23, 42, 0.8);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 8px;
        color: #e2e8f0;
        font-size: 0.95rem;
        transition: border-color 0.2s;
    }

    .form-control:focus {
        outline: none;
        border-color: var(--primary);
    }

    .form-control::placeholder {
        color: #475569;
    }

    textarea.form-control {
        min-height: 150px;
        resize: vertical;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }

    .submit-btn {
        width: 100%;
        padding: 1rem;
        margin-top: 0.5rem;
    }

    .social-links {
        display: flex;
        gap: 1rem;
        margin-top: 1rem;
    }

    .social-link {
        width: 45px;
        height: 45px;
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s;
    }

    .social-link:hover {
        background: var(--primary);
        border-color: var(--primary);
    }

    .social-link i {
        font-size: 1.25rem;
        color: #94a3b8;
    }

    .social-link:hover i {
        color: white;
    }

    .error-message {
        color: var(--danger);
        font-size: 0.85rem;
        margin-top: 0.25rem;
    }

    @media (max-width: 968px) {
        .contact-grid {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 576px) {
        .form-row {
            grid-template-columns: 1fr;
        }
    }
</style>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <div class="breadcrumb">
            <a href="{{ route('shop.home') }}">Home</a>
            <span>/</span>
            <span>Contact</span>
        </div>
        <h1>Contact Us</h1>
        <p>We're here to help with all your security equipment needs</p>
    </div>
</div>

<!-- Main Content -->
<div class="main-content">
    @if(session('success'))
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    <div class="contact-grid">
        <!-- Contact Info -->
        <div class="contact-info">
            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fas fa-phone"></i>
                </div>
                <div>
                    <h3>Phone</h3>
                    <p>Give us a call for quick assistance</p>
                    <a href="tel:+254743456809">+254 743 456 809</a>
                </div>
            </div>

            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <div>
                    <h3>Email</h3>
                    <p>Send us an email anytime</p>
                    <a href="mailto:info@onespotsolutions.co.ke">info@onespotsolutions.co.ke</a>
                </div>
            </div>

            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fab fa-whatsapp"></i>
                </div>
                <div>
                    <h3>WhatsApp</h3>
                    <p>Chat with us on WhatsApp</p>
                    <a href="https://wa.me/254743456809">+254 743 456 809</a>
                </div>
            </div>

            <div class="contact-card">
                <div class="contact-icon">
                    <i class="fas fa-map-marker-alt"></i>
                </div>
                <div>
                    <h3>Location</h3>
                    <p>Visit our showroom</p>
                    <a href="#">Nairobi, Kenya</a>
                </div>
            </div>

            <div class="business-hours">
                <h3><i class="fas fa-clock"></i> Business Hours</h3>
                <div class="hours-list">
                    <div class="hours-item">
                        <span>Monday - Friday</span>
                        <span>8:00 AM - 6:00 PM</span>
                    </div>
                    <div class="hours-item">
                        <span>Saturday</span>
                        <span>9:00 AM - 4:00 PM</span>
                    </div>
                    <div class="hours-item">
                        <span>Sunday</span>
                        <span>Closed</span>
                    </div>
                </div>
            </div>

            <div>
                <h4 style="margin-bottom: 0.75rem; color: #94a3b8; font-size: 0.9rem;">Follow Us</h4>
                <div class="social-links">
                    <a href="#" class="social-link"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-link"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-link"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>
        </div>

        <!-- Contact Form -->
        <div class="contact-form-card">
            <h2>Send us a Message</h2>
            <p>Fill out the form below and we'll get back to you as soon as possible.</p>

            <form action="{{ route('shop.contact.send') }}" method="POST">
                @csrf

                <div class="form-row">
                    <div class="form-group">
                        <label>Full Name <span class="required">*</span></label>
                        <input type="text" name="name" class="form-control" placeholder="John Doe" value="{{ old('name') }}" required>
                        @error('name')
                            <div class="error-message">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label>Email Address <span class="required">*</span></label>
                        <input type="email" name="email" class="form-control" placeholder="john@example.com" value="{{ old('email') }}" required>
                        @error('email')
                            <div class="error-message">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label>Phone Number</label>
                        <input type="tel" name="phone" class="form-control" placeholder="+254 7XX XXX XXX" value="{{ old('phone') }}">
                        @error('phone')
                            <div class="error-message">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label>Subject <span class="required">*</span></label>
                        <select name="subject" class="form-control" required>
                            <option value="">Select a subject</option>
                            <option value="Product Inquiry" {{ old('subject') == 'Product Inquiry' ? 'selected' : '' }}>Product Inquiry</option>
                            <option value="Installation Quote" {{ old('subject') == 'Installation Quote' ? 'selected' : '' }}>Installation Quote</option>
                            <option value="Technical Support" {{ old('subject') == 'Technical Support' ? 'selected' : '' }}>Technical Support</option>
                            <option value="Order Status" {{ old('subject') == 'Order Status' ? 'selected' : '' }}>Order Status</option>
                            <option value="General Inquiry" {{ old('subject') == 'General Inquiry' ? 'selected' : '' }}>General Inquiry</option>
                            <option value="Other" {{ old('subject') == 'Other' ? 'selected' : '' }}>Other</option>
                        </select>
                        @error('subject')
                            <div class="error-message">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="form-group">
                    <label>Message <span class="required">*</span></label>
                    <textarea name="message" class="form-control" placeholder="Tell us how we can help you..." required>{{ old('message') }}</textarea>
                    @error('message')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                <button type="submit" class="btn btn-primary submit-btn">
                    <i class="fas fa-paper-plane"></i> Send Message
                </button>
            </form>
        </div>
    </div>
</div>
@endsection
