<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', config('app.name', 'Onespot Solutions Shop'))</title>
    <meta name="description" content="@yield('description', 'Premium security equipment shop - CCTV cameras, access controls, smart locks, and more.')">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=inter:400,500,600,700,800&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />

    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        :root {
            --primary: #0ea5e9;
            --primary-dark: #0284c7;
            --secondary: #64748b;
            --success: #22c55e;
            --danger: #ef4444;
            --warning: #f59e0b;
            --dark: #0f172a;
            --darker: #020617;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: var(--dark);
            color: #e2e8f0;
            line-height: 1.6;
        }

        a {
            color: inherit;
            text-decoration: none;
        }

        /* Navigation */
        .navbar {
            background: rgba(15, 23, 42, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            height: 70px;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-weight: 700;
            font-size: 1.25rem;
        }

        .logo i {
            font-size: 1.5rem;
            color: var(--primary);
        }

        .logo span {
            background: linear-gradient(90deg, #0ea5e9, #22c55e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .nav-links {
            display: flex;
            align-items: center;
            gap: 2rem;
        }

        .nav-links a {
            color: #94a3b8;
            font-weight: 500;
            transition: color 0.2s;
        }

        .nav-links a:hover,
        .nav-links a.active {
            color: var(--primary);
        }

        .nav-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .cart-btn {
            position: relative;
            padding: 0.5rem 1rem;
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.3);
            border-radius: 8px;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .cart-badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: var(--danger);
            color: white;
            font-size: 0.7rem;
            font-weight: 600;
            padding: 2px 6px;
            border-radius: 999px;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.625rem 1.25rem;
            border-radius: 8px;
            font-weight: 500;
            font-size: 0.875rem;
            border: none;
            cursor: pointer;
            transition: all 0.2s;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
        }

        .btn-secondary {
            background: rgba(100, 116, 139, 0.2);
            color: #94a3b8;
            border: 1px solid rgba(100, 116, 139, 0.3);
        }

        .btn-secondary:hover {
            background: rgba(100, 116, 139, 0.3);
        }

        /* Page Header */
        .page-header {
            background: linear-gradient(135deg, var(--darker) 0%, var(--dark) 50%, #0c1929 100%);
            padding: 3rem 2rem;
            position: relative;
            overflow: hidden;
        }

        .page-header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, rgba(14, 165, 233, 0.1) 0%, transparent 70%);
        }

        .page-header-content {
            max-width: 1400px;
            margin: 0 auto;
        }

        .page-header h1 {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .page-header p {
            color: #64748b;
            font-size: 1.1rem;
        }

        .breadcrumb {
            display: flex;
            gap: 0.5rem;
            margin-bottom: 1rem;
            font-size: 0.9rem;
        }

        .breadcrumb a {
            color: var(--primary);
        }

        .breadcrumb span {
            color: #64748b;
        }

        /* Main Content */
        .main-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 3rem 2rem;
        }

        /* Card Styles */
        .card {
            background: rgba(30, 41, 59, 0.6);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            padding: 1.5rem;
        }

        /* Footer */
        footer {
            background: var(--darker);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            padding: 4rem 2rem 2rem;
        }

        .footer-container {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 2fr repeat(3, 1fr);
            gap: 3rem;
        }

        .footer-brand h3 {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 1rem;
        }

        .footer-brand p {
            color: #64748b;
            font-size: 0.9rem;
            margin-bottom: 1.5rem;
        }

        .footer-section h4 {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: #94a3b8;
        }

        .footer-section ul {
            list-style: none;
        }

        .footer-section li {
            margin-bottom: 0.5rem;
        }

        .footer-section a {
            color: #64748b;
            font-size: 0.9rem;
            transition: color 0.2s;
        }

        .footer-section a:hover {
            color: var(--primary);
        }

        .footer-bottom {
            max-width: 1400px;
            margin: 3rem auto 0;
            padding-top: 2rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            text-align: center;
            color: #475569;
            font-size: 0.85rem;
        }

        /* Alert Messages */
        .alert {
            padding: 1rem 1.5rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }

        .alert-success {
            background: rgba(34, 197, 94, 0.2);
            border: 1px solid rgba(34, 197, 94, 0.3);
            color: var(--success);
        }

        .alert-error {
            background: rgba(239, 68, 68, 0.2);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: var(--danger);
        }

        @media (max-width: 1024px) {
            .footer-container {
                grid-template-columns: 1fr 1fr;
            }
        }

        @media (max-width: 768px) {
            .nav-links {
                display: none;
            }
            .footer-container {
                grid-template-columns: 1fr;
            }
            .page-header h1 {
                font-size: 1.75rem;
            }
            .mobile-toggle {
                display: block;
            }
        }

        /* Mobile Menu Styles */
        .mobile-toggle {
            display: none;
            background: transparent;
            border: none;
            color: #e2e8f0;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0.5rem;
        }

        .mobile-menu-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(4px);
            z-index: 2000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s;
        }

        .mobile-menu-overlay.show {
            opacity: 1;
            visibility: visible;
        }

        .mobile-menu {
            position: fixed;
            top: 0;
            right: 0;
            width: 300px;
            height: 100vh;
            background: var(--darker);
            border-left: 1px solid rgba(255, 255, 255, 0.1);
            z-index: 2001;
            transform: translateX(100%);
            transition: transform 0.3s ease-in-out;
            padding: 2rem;
            display: flex;
            flex-direction: column;
        }

        .mobile-menu.show {
            transform: translateX(0);
        }

        .mobile-nav-links {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
            margin-top: 2rem;
        }

        .mobile-nav-links a {
            font-size: 1.1rem;
            color: #94a3b8;
            font-weight: 500;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            padding-bottom: 1rem;
        }

        .mobile-nav-links a.active,
        .mobile-nav-links a:hover {
            color: var(--primary);
            padding-left: 10px;
        }
    </style>

    @stack('styles')
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <a href="{{ route('shop.home') }}" class="logo">
                <i class="fas fa-shield-halved"></i>
                <span>Onespot Solutions</span>
            </a>

            <div class="nav-links">
                <a href="{{ route('shop.home') }}" class="{{ request()->routeIs('shop.home') ? 'active' : '' }}">Home</a>
                <a href="{{ route('shop.products') }}" class="{{ request()->routeIs('shop.products') ? 'active' : '' }}">Products</a>
                <a href="{{ route('shop.categories') }}" class="{{ request()->routeIs('shop.categories') ? 'active' : '' }}">Categories</a>
                <a href="{{ route('shop.installation') }}" class="{{ request()->routeIs('shop.installation') ? 'active' : '' }}">Installation</a>
                <a href="{{ route('shop.contact') }}" class="{{ request()->routeIs('shop.contact') ? 'active' : '' }}">Contact</a>
            </div>

            <div class="nav-actions">
                @auth
                    <a href="{{ route('cart.index') }}" class="cart-btn">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="d-none d-md-inline">Cart</span>
                        <span class="cart-badge" id="cart-count">0</span>
                    </a>
                    @if(auth()->user()->isAdmin())
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary d-none d-md-inline-flex">Admin</a>
                    @else
                        <a href="{{ route('dashboard') }}" class="btn btn-secondary d-none d-md-inline-flex">Account</a>
                    @endif
                @else
                    <a href="{{ route('login') }}" class="cart-btn">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="d-none d-md-inline">Cart</span>
                    </a>
                    <a href="{{ route('login') }}" class="btn btn-secondary d-none d-md-inline-flex">Login</a>
                    <a href="{{ route('register') }}" class="btn btn-primary d-none d-md-inline-flex">Register</a>
                @endauth
                
                <button class="mobile-toggle" id="mobileMenuToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
    </nav>

    @yield('content')

    <!-- Footer -->
    <footer>
        <div class="footer-container">
            <div class="footer-brand">
                <h3>
                    <i class="fas fa-shield-halved" style="color: var(--primary);"></i>
                    Onespot Solutions
                </h3>
                <p>Your trusted partner for security equipment and installation services. We provide premium quality products with expert support.</p>
                <div style="display: flex; gap: 1rem;">
                    <a href="#" style="color: #64748b;"><i class="fab fa-facebook" style="font-size: 1.25rem;"></i></a>
                    <a href="#" style="color: #64748b;"><i class="fab fa-twitter" style="font-size: 1.25rem;"></i></a>
                    <a href="#" style="color: #64748b;"><i class="fab fa-instagram" style="font-size: 1.25rem;"></i></a>
                </div>
            </div>

            <div class="footer-section">
                <h4>Products</h4>
                <ul>
                    <li><a href="{{ route('shop.products') }}">CCTV Cameras</a></li>
                    <li><a href="{{ route('shop.products') }}">Access Control</a></li>
                    <li><a href="{{ route('shop.products') }}">Smart Locks</a></li>
                    <li><a href="{{ route('shop.products') }}">Electric Fencing</a></li>
                    <li><a href="{{ route('shop.products') }}">Networking</a></li>
                </ul>
            </div>

            <div class="footer-section">
                <h4>Services</h4>
                <ul>
                    <li><a href="{{ route('shop.installation') }}">Installation</a></li>
                    <li><a href="{{ route('shop.installation') }}">Maintenance</a></li>
                    <li><a href="{{ route('shop.installation') }}">Consultation</a></li>
                    <li><a href="{{ route('shop.contact') }}">Request Quote</a></li>
                </ul>
            </div>

            <div class="footer-section">
                <h4>Contact</h4>
                <ul>
                    <li><a href="tel:+254743456809"><i class="fas fa-phone"></i> +254 743 456 809</a></li>
                    <li><a href="mailto:info@onespotsolutions.co.ke"><i class="fas fa-envelope"></i> info@onespotsolutions.co.ke</a></li>
                    <li><a href="{{ route('shop.contact') }}"><i class="fas fa-map-marker-alt"></i> Nairobi, Kenya</a></li>
                </ul>
            </div>
        </div>

        <div class="footer-bottom">
            <p>&copy; {{ date('Y') }} One Spot Solutions. All rights reserved.</p>
        </div>
    </footer>

    @auth
    <script>
        // Update cart count on page load
        document.addEventListener('DOMContentLoaded', function() {
            fetch('{{ route("cart.count") }}')
                .then(response => response.json())
                .then(data => {
                    const badge = document.getElementById('cart-count');
                    if (badge) {
                        badge.textContent = data.count;
                        badge.style.display = data.count > 0 ? 'block' : 'none';
                    }
                })
                .catch(error => console.log('Could not fetch cart count'));
        });
    </script>
    @endauth

    <!-- Mobile Menu -->
    <div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>
    <div class="mobile-menu" id="mobileMenu">
        <div class="mobile-menu-header" style="display: flex; justify-content: space-between; align-items: center;">
            <div class="logo">
                <i class="fas fa-shield-halved"></i>
                <span>OneSpot</span>
            </div>
            <button class="mobile-toggle" id="closeMobileMenu" style="display: block;">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <div class="mobile-nav-links">
            <a href="{{ route('shop.home') }}" class="{{ request()->routeIs('shop.home') ? 'active' : '' }}">Home</a>
            <a href="{{ route('shop.products') }}" class="{{ request()->routeIs('shop.products') ? 'active' : '' }}">Products</a>
            <a href="{{ route('shop.categories') }}" class="{{ request()->routeIs('shop.categories') ? 'active' : '' }}">Categories</a>
            <a href="{{ route('shop.installation') }}" class="{{ request()->routeIs('shop.installation') ? 'active' : '' }}">Installation</a>
            <a href="{{ route('shop.contact') }}" class="{{ request()->routeIs('shop.contact') ? 'active' : '' }}">Contact</a>
            
            @auth
                @if(auth()->user()->isAdmin())
                    <a href="{{ route('admin.dashboard') }}" style="color: var(--secondary);">Admin Panel</a>
                @else
                    <a href="{{ route('dashboard') }}" style="color: var(--secondary);">My Account</a>
                @endif
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" style="background: none; border: none; color: var(--danger); font-size: 1.1rem; font-weight: 500; cursor: pointer; padding: 0; font-family: inherit;">Logout</button>
                </form>
            @else
                <a href="{{ route('login') }}" style="color: var(--primary);">Login</a>
                <a href="{{ route('register') }}" style="color: var(--success);">Create Account</a>
            @endauth
        </div>
    </div>

    @stack('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenu = document.getElementById('mobileMenu');
            const overlay = document.getElementById('mobileMenuOverlay');
            const toggle = document.getElementById('mobileMenuToggle');
            const close = document.getElementById('closeMobileMenu');

            function openMenu() {
                mobileMenu.classList.add('show');
                overlay.classList.add('show');
                document.body.style.overflow = 'hidden';
            }

            function closeMenu() {
                mobileMenu.classList.remove('show');
                overlay.classList.remove('show');
                document.body.style.overflow = '';
            }

            if(toggle) toggle.addEventListener('click', openMenu);
            if(close) close.addEventListener('click', closeMenu);
            if(overlay) overlay.addEventListener('click', closeMenu);
        });
    </script>
</body>
</html>
