<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: sans-serif; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { margin-bottom: 20px; }
        .footer { margin-top: 30px; font-size: 0.9em; color: #777; border-top: 1px solid #eee; padding-top: 10px; }
        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #0ea5e9;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Thank you for your order!</h2>
        </div>
        
        <p>Dear <?php echo e($order->customer_name); ?>,</p>
        
        <p>Your order <strong><?php echo e($order->order_number); ?></strong> has been successfully placed.</p>
        
        <p>Please find attached the invoice for your order.</p>
        
        <p><strong>Order Summary:</strong></p>
        <ul>
            <li>Order Number: <?php echo e($order->order_number); ?></li>
            <li>Tracking Status: <?php echo e(ucfirst($order->status)); ?></li>
            <li>Total Amount: KSh <?php echo e(number_format($order->total, 2)); ?></li>
        </ul>
        
        <p>If you have any questions, please feel free to reply to this email or contact us via WhatsApp at +254 740 940 303.</p>
        
        <div class="footer">
            <p>OneSpot Solutions Ltd<br>
            Nairobi, Kenya<br>
            <a href="<?php echo e(route('shop.home')); ?>">www.onespotsolutionsltd.co.ke</a></p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\shop\resources\views/emails/orders/invoice.blade.php ENDPATH**/ ?>