

<?php $__env->startSection('title', 'Orders'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">All Orders</h3>
    </div>

    <!-- Filters -->
    <form method="GET" class="mb-3">
        <div class="flex gap-3 items-center">
            <input type="text" name="search" class="form-input" placeholder="Search by order #, name, email..." 
                   value="<?php echo e(request('search')); ?>" style="max-width: 300px;">
            
            <select name="status" class="form-select" style="max-width: 150px;">
                <option value="">All Status</option>
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="processing" <?php echo e(request('status') == 'processing' ? 'selected' : ''); ?>>Processing</option>
                <option value="confirmed" <?php echo e(request('status') == 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                <option value="shipped" <?php echo e(request('status') == 'shipped' ? 'selected' : ''); ?>>Shipped</option>
                <option value="delivered" <?php echo e(request('status') == 'delivered' ? 'selected' : ''); ?>>Delivered</option>
                <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
            </select>

            <select name="payment_status" class="form-select" style="max-width: 150px;">
                <option value="">All Payments</option>
                <option value="pending" <?php echo e(request('payment_status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                <option value="paid" <?php echo e(request('payment_status') == 'paid' ? 'selected' : ''); ?>>Paid</option>
                <option value="failed" <?php echo e(request('payment_status') == 'failed' ? 'selected' : ''); ?>>Failed</option>
            </select>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-search"></i> Filter
            </button>
            
            <?php if(request()->hasAny(['search', 'status', 'payment_status'])): ?>
                <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn-secondary">Clear</a>
            <?php endif; ?>
        </div>
    </form>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Order #</th>
                    <th>Customer</th>
                    <th>Items</th>
                    <th>Total</th>
                    <th>Payment</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="text-primary">
                            <strong><?php echo e($order->order_number); ?></strong>
                        </a>
                    </td>
                    <td>
                        <div>
                            <strong><?php echo e($order->customer_name); ?></strong>
                            <div class="text-muted" style="font-size: 0.8rem;"><?php echo e($order->customer_phone); ?></div>
                        </div>
                    </td>
                    <td><?php echo e($order->items->count()); ?> items</td>
                    <td><strong>KSh <?php echo e(number_format($order->total, 2)); ?></strong></td>
                    <td>
                        <span class="badge badge-<?php echo e($order->payment_status_badge['color']); ?>">
                            <?php echo e($order->payment_status_badge['label']); ?>

                        </span>
                        <?php if($order->payment_method): ?>
                            <div class="text-muted" style="font-size: 0.75rem; margin-top: 2px;">
                                <?php echo e(strtoupper($order->payment_method)); ?>

                            </div>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="badge badge-<?php echo e($order->status_badge['color']); ?>">
                            <?php echo e($order->status_badge['label']); ?>

                        </span>
                    </td>
                    <td>
                        <div class="text-muted" style="font-size: 0.85rem;">
                            <?php echo e($order->created_at->format('M d, Y')); ?>

                            <br>
                            <span style="font-size: 0.75rem;"><?php echo e($order->created_at->format('h:i A')); ?></span>
                        </div>
                    </td>
                    <td>
                        <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" class="text-muted" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-shopping-cart" style="font-size: 2rem; margin-bottom: 1rem; display: block;"></i>
                        No orders yet
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo e($orders->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\shop\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>