<nav x-data="{ open: false }" class="dashboard-nav">
    <style>
        .dashboard-nav {
            background: rgba(15, 23, 42, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .dashboard-nav .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 64px;
        }

        .dashboard-nav .nav-left {
            display: flex;
            align-items: center;
            gap: 3rem;
        }

        .dashboard-nav .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            text-decoration: none;
        }

        .dashboard-nav .logo i {
            font-size: 1.5rem;
            color: #0ea5e9;
        }

        .dashboard-nav .logo-text {
            font-weight: 700;
            font-size: 1.25rem;
            background: linear-gradient(90deg, #0ea5e9, #22c55e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .dashboard-nav .nav-links {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .dashboard-nav .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            color: #94a3b8;
            text-decoration: none;
            font-weight: 500;
            font-size: 0.875rem;
            border-radius: 8px;
            transition: all 0.2s;
        }

        .dashboard-nav .nav-link:hover {
            color: #0ea5e9;
            background: rgba(14, 165, 233, 0.1);
        }

        .dashboard-nav .nav-link.active {
            color: #0ea5e9;
            background: rgba(14, 165, 233, 0.15);
        }

        .dashboard-nav .nav-right {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .dashboard-nav .shop-btn {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: rgba(14, 165, 233, 0.1);
            border: 1px solid rgba(14, 165, 233, 0.3);
            border-radius: 8px;
            color: #0ea5e9;
            text-decoration: none;
            font-weight: 500;
            font-size: 0.875rem;
            transition: all 0.2s;
        }

        .dashboard-nav .shop-btn:hover {
            background: rgba(14, 165, 233, 0.2);
        }

        .dashboard-nav .user-menu {
            position: relative;
        }

        .dashboard-nav .user-btn {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem;
            background: transparent;
            border: none;
            cursor: pointer;
            color: #e2e8f0;
        }

        .dashboard-nav .user-avatar {
            width: 36px;
            height: 36px;
            background: linear-gradient(135deg, #0ea5e9, #22c55e);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 0.875rem;
            color: white;
        }

        .dashboard-nav .user-info {
            text-align: left;
        }

        .dashboard-nav .user-name {
            font-weight: 500;
            font-size: 0.875rem;
            color: #f1f5f9;
        }

        .dashboard-nav .user-role {
            font-size: 0.75rem;
            color: #64748b;
        }

        .dashboard-nav .dropdown-icon {
            color: #64748b;
            font-size: 0.75rem;
        }

        .dashboard-nav .dropdown-menu {
            position: absolute;
            right: 0;
            top: calc(100% + 0.5rem);
            background: rgba(30, 41, 59, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            padding: 0.5rem;
            min-width: 200px;
            box-shadow: 0 20px 40px -15px rgba(0, 0, 0, 0.5);
            z-index: 1000;
        }

        .dashboard-nav .dropdown-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: #94a3b8;
            text-decoration: none;
            font-size: 0.875rem;
            border-radius: 8px;
            transition: all 0.2s;
        }

        .dashboard-nav .dropdown-item:hover {
            background: rgba(14, 165, 233, 0.1);
            color: #f1f5f9;
        }

        .dashboard-nav .dropdown-item.danger:hover {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
        }

        .dashboard-nav .dropdown-divider {
            height: 1px;
            background: rgba(255, 255, 255, 0.1);
            margin: 0.5rem 0;
        }

        /* Mobile Menu */
        .dashboard-nav .mobile-toggle {
            display: none;
            padding: 0.5rem;
            background: transparent;
            border: none;
            color: #94a3b8;
            cursor: pointer;
            font-size: 1.25rem;
        }

        .dashboard-nav .mobile-menu {
            display: none;
            padding: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .dashboard-nav .mobile-menu .nav-link {
            display: flex;
            padding: 0.875rem 1rem;
        }

        @media (max-width: 768px) {
            .dashboard-nav .nav-links,
            .dashboard-nav .user-info {
                display: none;
            }

            .dashboard-nav .mobile-toggle {
                display: block;
            }

            .dashboard-nav .mobile-menu.open {
                display: block;
            }

            .dashboard-nav .nav-container {
                padding: 0 1rem;
            }
        }
    </style>

    <div class="nav-container">
        <div class="nav-left">
            <a href="<?php echo e(route('dashboard')); ?>" class="logo">
                <i class="fas fa-shield-halved"></i>
                <span class="logo-text">OneSpot</span>
            </a>

            <div class="nav-links">
                <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                    <i class="fas fa-home"></i>
                    Dashboard
                </a>
                <a href="<?php echo e(route('cart.index')); ?>" class="nav-link <?php echo e(request()->routeIs('cart.*') ? 'active' : ''); ?>">
                    <i class="fas fa-shopping-cart"></i>
                    My Cart
                </a>
                <a href="<?php echo e(route('profile.edit')); ?>" class="nav-link <?php echo e(request()->routeIs('profile.*') ? 'active' : ''); ?>">
                    <i class="fas fa-user"></i>
                    Profile
                </a>
            </div>
        </div>

        <div class="nav-right">
            <a href="<?php echo e(route('shop.home')); ?>" class="shop-btn">
                <i class="fas fa-store"></i>
                <span>Shop</span>
            </a>

            <div class="user-menu" x-data="{ open: false }">
                <button @click="open = !open" class="user-btn">
                    <div class="user-avatar">
                        <?php echo e(strtoupper(substr(Auth::user()->name, 0, 1))); ?>

                    </div>
                    <div class="user-info">
                        <div class="user-name"><?php echo e(Auth::user()->name); ?></div>
                        <div class="user-role">Customer</div>
                    </div>
                    <i class="fas fa-chevron-down dropdown-icon"></i>
                </button>

                <div class="dropdown-menu" x-show="open" @click.away="open = false" x-transition>
                    <a href="<?php echo e(route('profile.edit')); ?>" class="dropdown-item">
                        <i class="fas fa-user-cog"></i>
                        Account Settings
                    </a>
                    <a href="<?php echo e(route('cart.index')); ?>" class="dropdown-item">
                        <i class="fas fa-shopping-bag"></i>
                        My Orders
                    </a>
                    <div class="dropdown-divider"></div>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <a href="<?php echo e(route('logout')); ?>" class="dropdown-item danger"
                            onclick="event.preventDefault(); this.closest('form').submit();">
                            <i class="fas fa-sign-out-alt"></i>
                            Log Out
                        </a>
                    </form>
                </div>
            </div>

            <button @click="open = !open" class="mobile-toggle">
                <i class="fas" :class="open ? 'fa-times' : 'fa-bars'"></i>
            </button>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div class="mobile-menu" :class="open ? 'open' : ''">
        <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
            <i class="fas fa-home"></i>
            Dashboard
        </a>
        <a href="<?php echo e(route('cart.index')); ?>" class="nav-link <?php echo e(request()->routeIs('cart.*') ? 'active' : ''); ?>">
            <i class="fas fa-shopping-cart"></i>
            My Cart
        </a>
        <a href="<?php echo e(route('profile.edit')); ?>" class="nav-link <?php echo e(request()->routeIs('profile.*') ? 'active' : ''); ?>">
            <i class="fas fa-user"></i>
            Profile
        </a>
        <a href="<?php echo e(route('shop.home')); ?>" class="nav-link">
            <i class="fas fa-store"></i>
            Shop
        </a>
        <div class="dropdown-divider" style="margin: 0.5rem 0;"></div>
        <form method="POST" action="<?php echo e(route('logout')); ?>">
            <?php echo csrf_field(); ?>
            <a href="<?php echo e(route('logout')); ?>" class="nav-link" style="color: #ef4444;"
                onclick="event.preventDefault(); this.closest('form').submit();">
                <i class="fas fa-sign-out-alt"></i>
                Log Out
            </a>
        </form>
    </div>
</nav>
<?php /**PATH C:\xampp\htdocs\shop\resources\views/layouts/navigation.blade.php ENDPATH**/ ?>